function ChangeSequence(){
	var sequence1 = null;
	var sequence2 = null;
	
	 function clickOnSequence(){
		$("#whole-RNA").on("click", "div.element", function(){
			saddeInputs();
			var sequenceId = $(this).attr("id");
			var stringSequence = sequenceId.replace('-', "'");
			sequence1 = rnaStructure.getSequence(stringSequence);
			colors.setColor(sequenceId, sequence1.getPairId());
			sequence2 = sequence1.getPair();
			if(sequence1.getName().indexOf("'") !== -1){
				swapSequences();
			}
			highlightElemets();
			$('#tab').tabs("option", "active", 1);
			$("#add-sequence").hide();
			$("#sequence-details").show();	
			fillImputs();
		});
	}
	clickOnSequence();
	
	function fillImputs(){
		$("#name1").text(sequence1.getName());
		$("#mistakes1").val(sequence1.getMistakes());
		$("#pattern1").val(sequence1.getPattern());
		var param = sequence1.getInsertion();
		$("#insertionNumber").val(param[0]);
		$("#insertionLetter").val(param[1]);
		
		if(sequence2 === null && typeof sequence2 === "object"){
			$("#secondPart").hide();
			$("#thirdPart").hide();
			return;
		}
		$("#secondPart").show();
		$("#name2").text(sequence2.getName());
		$("#mistakes2").val(sequence2.getMistakes());
		$("#pattern2").val(sequence2.getPattern());
		
		if(sequence1.getName()[0] !== "r"){
			$("#thirdPart").hide();
			return;
		}
		$("#thirdPart").show();
		$("#alphabet").val(sequence1.getRule());
	}
	
	function SaveSequence(){
		$("#SaveButton").click(function(){
			$(".warnning").remove();
			if(checkEmptiness($("#mistakes1"), $("#pattern1"))){  
				return;
			}else if(checkInsertion($("#insertionNumber"), $("#insertionLetter"))){
				return;
			}
			
			if(sequence2 !== null || typeof sequence2 !== "object"){
				if(checkEmptiness($("#mistakes2"), $("#pattern2"))){
					return;
				}
				if(checkPairOrder($("#pattern1"), $("#pattern2"))){
					return;
				}
			}
			
			if(sequence1.getName()[0] === "r"){
				if( checkAlphabet($("#alphabet")) ){
					return;
				}
			}
			
			sequence1.setMistakes(parseInt($("#mistakes1").val()));
			sequence1.setPattern($("#pattern1").val().toUpperCase());
			var insertionNum = parseInt($("#insertionNumber").val());
			var insertionLetter = $("#insertionLetter").val().toUpperCase();
			sequence1.setInsertion(insertionNum, insertionLetter);
			if(sequence2 !== null || typeof sequence2 !== "object"){
				sequence2.setMistakes(parseInt($("#mistakes2").val()));
				sequence2.setPattern($("#pattern2").val().toUpperCase());
				sequence2.setInsertion(insertionNum, insertionLetter);
			}
			if(sequence1.getName()[0] === "r"){
				sequence1.setRule($("#alphabet").val().toUpperCase());
				sequence2.setRule($("#alphabet").val().toUpperCase());
			}
			rnaStructure.exchangeDictionaries();
		});
	}
	SaveSequence();
	
	
	function RemoveSequence(){
		$("#RemoveButton").click(function(){
			$(".warnning").remove();
			var name = sequence1.getName()
			var order = name.slice(1, name.length);
			order = parseInt(order.replace("'", ""));
			if(name[0] === "h" || name[0] === "r"){
				rnaStructure.removeSequenceHR(name[0], order);
			}
			else if(name[0] === "s"){
				rnaStructure.removeSequenceS(name[0], order);
			}
			$("#sequence-details").hide();
		});
	}
	RemoveSequence();
	
	function highlightElemets(){
		$(".element, .dash").removeClass("selected");
		var id1 = "#" + sequence1.getId();
		$(id1).addClass("selected");
		if(sequence2 === null && typeof sequence2 === "object"){
			return;
		}
		var id2 = "#" + sequence2.getId();
		$(id2).addClass("selected");
	}
	
	function swapSequences(){
		var s = sequence1;
		sequence1 = sequence2;
		sequence2 = s;
	}
	
	function saddeInputs(){
		$(".warnning").remove();
		$("#mistakes1").css("border", "1px solid gray");
		$("#pattern1").css("border", "1px solid gray");
		$("#mistakes2").css("border", "1px solid gray");
		$("#pattern2").css("border", "1px solid gray");
		$("#alphabet").css("border", "1px solid gray");
		$("#insertionNumber").css("border", "1px solid gray");
		$("#insertionLetter").css("border", "1px solid gray");
	}
}